/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.infernalstudios.infernalexp.entities.AscusBombEntity;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IEShroomloinTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.util.ShroomloinType;

public class ShroomloinEntity
extends PathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(ShroomloinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(ShroomloinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(ShroomloinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(ShroomloinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private final int fuseTime = 59;
    private int conversionTicks;
    private ShroomloinType predictedType;

    public ShroomloinEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22279_, 0.6);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
        this.f_19804_.m_135372_(CONVERTING, (Object)false);
        this.f_19804_.m_135372_(TYPE, (Object)IEShroomloinTypes.CRIMSON.getId().toString());
    }

    public boolean isConverting() {
        return (Boolean)this.f_19804_.m_135370_(CONVERTING);
    }

    public void setConverting(boolean converting) {
        this.f_19804_.m_135381_(CONVERTING, (Object)converting);
    }

    public boolean isShaking() {
        return this.isConverting();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("ShroomloinType", this.getShroomloinType().getId().toString());
        compound.m_128405_("ShroomloinConversionTime", this.isConverting() ? this.conversionTicks : -1);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ShroomloinType type = ShroomloinType.getById(compound.m_128461_("ShroomloinType"));
        if (type == null) {
            type = IEShroomloinTypes.CRIMSON;
        }
        this.setShroomloinType(type);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Optional biomeKey = worldIn.m_204166_(this.m_20183_()).m_203543_();
        if (reason == MobSpawnType.NATURAL && biomeKey.isPresent() && ModList.get().isLoaded("byg")) {
            if (((ResourceKey)biomeKey.get()).m_135782_().equals((Object)new ResourceLocation("byg", "glowstone_gardens"))) {
                if (this.f_19796_.m_188499_()) {
                    this.setShroomloinType(IEShroomloinTypes.SOUL_SHROOM);
                } else {
                    this.setShroomloinType(IEShroomloinTypes.DEATH_CAP);
                }
            } else if (((ResourceKey)biomeKey.get()).m_135782_().equals((Object)new ResourceLocation("byg", "embur_bog"))) {
                this.setShroomloinType(IEShroomloinTypes.EMBUR);
            } else if (((ResourceKey)biomeKey.get()).m_135782_().equals((Object)new ResourceLocation("byg", "sythian_torrids"))) {
                this.setShroomloinType(IEShroomloinTypes.SYTHIAN_FUNGUS);
            }
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setShroomloinType(ShroomloinType shroomloinType) {
        this.f_19804_.m_135381_(TYPE, (Object)shroomloinType.getId().toString());
    }

    public ShroomloinType getShroomloinType() {
        return ShroomloinType.getById((String)this.f_19804_.m_135370_(TYPE));
    }

    public Item getConversionItem() {
        return this.getShroomloinType().getConversionItem();
    }

    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        if (this.isConverting()) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = playerIn.m_21120_(hand);
        ShroomloinType shroomloinType = ShroomloinType.getByItem(stack.m_41720_());
        if (shroomloinType == null || shroomloinType.getConversionItem() == null) {
            return super.m_6071_(playerIn, hand);
        }
        if (shroomloinType.getId().equals((Object)this.getShroomloinType().getId()) || shroomloinType == IEShroomloinTypes.PIZZA) {
            return InteractionResult.FAIL;
        }
        this.predictedType = shroomloinType;
        this.conversionTicks = 40;
        this.setConverting(true);
        if (!playerIn.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            if (this.m_7755_().m_214077_().toString().equals("pizza") && this.getShroomloinType() != IEShroomloinTypes.PIZZA && this.predictedType != IEShroomloinTypes.PIZZA) {
                this.predictedType = IEShroomloinTypes.PIZZA;
                this.conversionTicks = 40;
                this.setConverting(true);
            }
            if (this.isConverting() && this.conversionTicks > 0) {
                --this.conversionTicks;
                this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                if (this.conversionTicks == 0) {
                    this.m_21051_(Attributes.f_22279_).m_22100_(0.6);
                    this.setShroomloinType(this.predictedType);
                    this.setConverting(false);
                }
            }
            if (this.m_21023_((MobEffect)IEEffects.INFECTION.get())) {
                this.m_6234_((MobEffect)IEEffects.INFECTION.get());
            }
            if (this.m_21023_(MobEffects.f_19614_)) {
                this.m_6234_(MobEffects.f_19614_);
            }
        }
        this.lastActiveTime = this.timeSinceIgnited;
        int i = this.getShroomloinState();
        if (i > 0 && this.timeSinceIgnited == 0) {
            this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
        }
        this.timeSinceIgnited += i;
        if (this.timeSinceIgnited < 0 || this.timeSinceIgnited >= this.fuseTime || i < 0) {
            this.timeSinceIgnited = 0;
        }
        super.m_8119_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackUnInfectedGoal(this, 1.0, 60, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackInfectedGoal(this, 0.6, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new ShroomloinTargetGoal(this, new Class[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShroomloinFlashIntensity(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getShroomloinState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setShroomloinState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public void becomeAngryAt(LivingEntity entity) {
        this.m_6710_(entity);
    }

    public int m_213860_() {
        return 1 + this.f_19853_.f_46441_.m_188503_(4);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IESoundEvents.SHROOMLOIN_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IESoundEvents.SHROOMLOIN_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.SHROOMLOIN_HURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        Vec3 vector3d = target.m_20184_();
        double x = target.m_20185_() + vector3d.f_82479_ - this.m_20185_();
        double y = target.m_20188_() - 1.1 - this.m_20186_();
        double z = target.m_20189_() + vector3d.f_82481_ - this.m_20189_();
        float distance = Mth.m_14116_((float)((float)(x * x + z * z)));
        AscusBombEntity ascusBombEntity = new AscusBombEntity(this.f_19853_, (LivingEntity)this);
        ascusBombEntity.m_37446_(new ItemStack((ItemLike)IEItems.ASCUS_BOMB.get()));
        ascusBombEntity.m_146926_(-20.0f);
        ascusBombEntity.m_6686_(x, y + (double)distance * 0.2, z, 0.75f, 8.0f);
        this.setShroomloinState(-1);
        this.f_19853_.m_7967_((Entity)ascusBombEntity);
    }

    static class RangedAttackUnInfectedGoal
    extends Goal {
        private final ShroomloinEntity entityHost;
        private final RangedAttackMob rangedAttackEntityHost;
        private LivingEntity attackTarget;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private int seeTime;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public RangedAttackUnInfectedGoal(RangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public RangedAttackUnInfectedGoal(RangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            if (!(attacker instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackEntityHost = attacker;
            this.entityHost = (ShroomloinEntity)attacker;
            this.entityMoveSpeed = movespeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity attackTarget = this.entityHost.m_5448_();
            if (attackTarget != null && attackTarget.m_6084_() && !attackTarget.m_21023_((MobEffect)IEEffects.INFECTION.get())) {
                this.attackTarget = attackTarget;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.entityHost.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.attackTarget = null;
            this.seeTime = 0;
            this.rangedAttackTime = -1;
            this.entityHost.setShroomloinState(-1);
        }

        public void m_8037_() {
            double d0 = this.entityHost.m_20275_(this.attackTarget.m_20185_(), this.attackTarget.m_20186_(), this.attackTarget.m_20189_());
            boolean flag = this.entityHost.m_21574_().m_148306_((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
                this.entityHost.m_21573_().m_26573_();
            } else {
                this.entityHost.setShroomloinState(-1);
                this.entityHost.m_21573_().m_5624_((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = Mth.m_14116_((float)((float)d0)) / this.attackRadius;
                float lvt_5_1_ = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackEntityHost.m_6504_(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = Mth.m_14116_((float)((float)d0)) / this.attackRadius;
                this.rangedAttackTime = Mth.m_14143_((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else {
                this.entityHost.setShroomloinState(1);
            }
        }
    }

    static class MeleeAttackInfectedGoal
    extends MeleeAttackGoal {
        public MeleeAttackInfectedGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean m_8036_() {
            LivingEntity attackTarget = this.f_25540_.m_5448_();
            if (attackTarget != null && !attackTarget.m_21023_((MobEffect)IEEffects.INFECTION.get())) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            LivingEntity attackTarget = this.f_25540_.m_5448_();
            if (attackTarget != null && !attackTarget.m_21023_((MobEffect)IEEffects.INFECTION.get())) {
                return false;
            }
            return super.m_8045_();
        }
    }

    static class ShroomloinTargetGoal
    extends HurtByTargetGoal {
        private final ShroomloinEntity shroomloin;

        public ShroomloinTargetGoal(ShroomloinEntity shroomloin, Class<?> ... excludeReinforcementTypes) {
            super((PathfinderMob)shroomloin, (Class[])excludeReinforcementTypes);
            this.shroomloin = shroomloin;
        }

        public boolean m_8036_() {
            if (this.shroomloin.isConverting()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.shroomloin.isConverting()) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

